package gov.va.med.mhv.usermgmt.data.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "HEALTH_INSURANCES")
public class HealthInsurances implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "HEALTH_INSURANCE_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long healthInsuranceId;

	private String comments;

	@Column(name = "COMPANY_NAME")
	private String companyName;

	@Column(name = "COMPANY_PHONE")
	private String companyPhone;

	@Column(name = "FIRST_NAME_OF_INSURED")
	private String firstNameOfInsured;

	@Column(name = "GROUP_NUMBER")
	private String groupNumber;

	@Column(name = "INSURANCE_ID_NUMBER")
	private String insuranceIdNumber;

	@Column(name = "LAST_NAME_OF_INSURED")
	private String lastNameOfInsured;

	private Integer oplock;

	@Column(name = "PRE_APPROVAL_PHONE")
	private String preApprovalPhone;

	@Column(name = "PRIMARY_IND")
	private Integer primaryInd;

	@Temporal(TemporalType.DATE)
	@Column(name = "START_DATE")
	private Date startDate;

	@Temporal(TemporalType.DATE)
	@Column(name = "STOP_DATE")
	private Date stopDate;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userProfileId;

	public HealthInsurances() {
	}

	public Long getHealthInsuranceId() {
		return this.healthInsuranceId;
	}

	public void setHealthInsuranceId(Long healthInsuranceId) {
		this.healthInsuranceId = healthInsuranceId;
	}

	public String getComments() {
		return this.comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getCompanyName() {
		return this.companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getCompanyPhone() {
		return this.companyPhone;
	}

	public void setCompanyPhone(String companyPhone) {
		this.companyPhone = companyPhone;
	}

	public String getFirstNameOfInsured() {
		return this.firstNameOfInsured;
	}

	public void setFirstNameOfInsured(String firstNameOfInsured) {
		this.firstNameOfInsured = firstNameOfInsured;
	}

	public String getGroupNumber() {
		return this.groupNumber;
	}

	public void setGroupNumber(String groupNumber) {
		this.groupNumber = groupNumber;
	}

	public String getInsuranceIdNumber() {
		return this.insuranceIdNumber;
	}

	public void setInsuranceIdNumber(String insuranceIdNumber) {
		this.insuranceIdNumber = insuranceIdNumber;
	}

	public String getLastNameOfInsured() {
		return this.lastNameOfInsured;
	}

	public void setLastNameOfInsured(String lastNameOfInsured) {
		this.lastNameOfInsured = lastNameOfInsured;
	}

	public String getPreApprovalPhone() {
		return this.preApprovalPhone;
	}

	public void setPreApprovalPhone(String preApprovalPhone) {
		this.preApprovalPhone = preApprovalPhone;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getStopDate() {
		return this.stopDate;
	}

	public void setStopDate(Date stopDate) {
		this.stopDate = stopDate;
	}

	public Long getUserProfileId() {
		return this.userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public Integer getPrimaryInd() {
		return primaryInd;
	}

	public void setPrimaryInd(Integer primaryInd) {
		this.primaryInd = primaryInd;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

}